package benchmarks;

import java.io.IOException;

import net.minidev.json.JSONValue;

public class SmartJSONLib implements TestMethods {

	@Override
	public byte[] serialize(Object o) throws IOException {
		return JSONValue.toJSONString(o).getBytes("UTF-8");
	}

	@Override
	public Object deserialize(byte[] b, Class c) throws IOException,
			ClassNotFoundException {
		return JSONValue.parse(new String(b, "UTF-8"));
	}

	@Override
	public Object copy(Object o) throws IOException, ClassNotFoundException {
		return deserialize(serialize(o), o.getClass());
	}

}
